/*
 * ReportContainerTableColumnNameGenerator.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.report;

import adams.gui.visualization.container.DefaultContainerTableColumnNameGenerator;

/**
 * Abstract class for generating the column names of a table.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1709 $
 */
public class ReportContainerTableColumnNameGenerator
  extends DefaultContainerTableColumnNameGenerator {

  /** for serialization. */
  private static final long serialVersionUID = 8910978103027731427L;

  /**
   * Returns the name of the column with the actual data in it.
   *
   * @return		the name
   */
  public String getData() {
    return "ID";
  }

  /**
   * Returns the width of the data column.
   *
   * @return		the width
   */
  public int getDataWidth() {
    return 120;
  }
}