/*
 * Amount.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.basedate;

import java.util.Calendar;

/**
 * Helper class for date manipulations (adding, substracting), stores the
 * type and amount.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 829 $
 * @see     Calendar#add(int, int)
 */
public class Amount {

  /** the type. */
  protected int m_Type;

  /** the amount. */
  protected int m_Amount;

  /**
   * Initializes the object with amount 1 of the specified type.
   *
   * @param type	the type
   */
  public Amount(int type) {
    this(type, 1);
  }

  /**
   * Initializes the object with specified amount and type.
   *
   * @param type	the type
   * @param amount	the amount
   */
  public Amount(int type, int amount) {
    m_Type   = type;
    m_Amount = amount;
  }

  /**
   * Returns the type.
   *
   * @return		the type
   */
  public int getType() {
    return m_Type;
  }

  /**
   * Returns the amount.
   *
   * @return		the amount
   */
  public int getAmount() {
    return m_Amount;
  }

  /**
   * Returns a string representation of the amount.
   *
   * @return		the string representation
   */
  public String toString() {
    return "Type=" + m_Type + ", Amount=" + m_Amount;
  }
}
