/*
 * IndexTest.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.test.AdamsTestCase;

/**
 * Tests the adams.core.Index class. Run from commandline with: <p/>
 * java adams.core.IndexTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class IndexTest
  extends AdamsTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public IndexTest(String name) {
    super(name);
  }

  /**
   * Tests "hasIndex".
   */
  public void testHasIndex() {
    Index	index;

    index = new Index();
    assertFalse(index.hasIndex());

    index = new Index("");
    assertFalse(index.hasIndex());

    index = new Index("1");
    assertTrue(index.hasIndex());

    index = new Index("1", 10);
    assertTrue(index.hasIndex());

    index = new Index("100", 10);
    assertTrue(index.hasIndex());
  }

  /**
   * Tests "first".
   */
  public void testFirst() {
    Index	index;

    index = new Index(Index.FIRST, 10);
    assertEquals(0, index.getIntIndex());
  }

  /**
   * Tests "second".
   */
  public void testSecond() {
    Index	index;

    index = new Index(Index.SECOND, 10);
    assertEquals(1, index.getIntIndex());
  }

  /**
   * Tests "third".
   */
  public void testThird() {
    Index	index;

    index = new Index(Index.THIRD, 10);
    assertEquals(2, index.getIntIndex());
  }

  /**
   * Tests "first", not-lowercase.
   */
  public void testFirstMixed() {
    Index	index;

    index = new Index("First", 10);
    assertEquals(0, index.getIntIndex());
  }

  /**
   * Tests "second", not-lowercase.
   */
  public void testSecondMixed() {
    Index	index;

    index = new Index("Second", 10);
    assertEquals(1, index.getIntIndex());
  }

  /**
   * Tests "third", not-lowercase.
   */
  public void testThirdMixed() {
    Index	index;

    index = new Index("Third", 10);
    assertEquals(2, index.getIntIndex());
  }

  /**
   * Tests "last_2".
   */
  public void testLastMinus2() {
    Index	index;

    index = new Index(Index.LAST_2, 10);
    assertEquals(index.getMax() - 3, index.getIntIndex());
  }

  /**
   * Tests "last_1".
   */
  public void testLastMinus1() {
    Index	index;

    index = new Index(Index.LAST_1, 10);
    assertEquals(index.getMax() - 2, index.getIntIndex());
  }

  /**
   * Tests "last".
   */
  public void testLast() {
    Index	index;

    index = new Index(Index.LAST, 10);
    assertEquals(index.getMax() - 1, index.getIntIndex());
  }

  /**
   * Tests "last_2", not-lowercase.
   */
  public void testLastMinus2Mixed() {
    Index	index;

    index = new Index("Last_2", 10);
    assertEquals(index.getMax() - 3, index.getIntIndex());
  }

  /**
   * Tests "last_1", not-lowercase.
   */
  public void testLastMinus1Mixed() {
    Index	index;

    index = new Index("Last_1", 10);
    assertEquals(index.getMax() - 2, index.getIntIndex());
  }

  /**
   * Tests "last", not-lowercase.
   */
  public void testLastMixed() {
    Index	index;

    index = new Index("Last", 10);
    assertEquals(index.getMax() - 1, index.getIntIndex());
  }

  /**
   * Tests a number.
   */
  public void testNumber() {
    Index	index;

    index = new Index("3", 10);
    assertEquals(2, index.getIntIndex());
  }

  /**
   * Tests an invalid index.
   */
  public void testInvalidIndex() {
    Index	index;

    index = new Index("blah", 10);
    assertEquals(-1, index.getIntIndex());
  }

  /**
   * Tests an no maximum.
   */
  public void testNoMax() {
    Index	index;

    index = new Index(Index.FIRST);
    assertEquals(-1, index.getIntIndex());
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(IndexTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
