/*
 * PlaceholdersTest.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

import java.io.File;
import java.util.Enumeration;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.test.AdamsTestCase;

/**
 * Tests the adams.core.Placeholders class. Run from commandline with: <p/>
 * java adams.core.PlaceholdersTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class PlaceholdersTest
  extends AdamsTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public PlaceholdersTest(String name) {
    super(name);
  }

  /**
   * Tests all placeholders.
   */
  public void testGeneric() {
    Enumeration<String>	keys;
    String		key;
    String		expanded;
    String		collapsed;
    Placeholders	ph;

    ph   = Placeholders.getSingleton();
    keys = ph.placeholders();
    while (keys.hasMoreElements()) {
      key       = keys.nextElement();
      collapsed = ph.get(key) + File.separator + "hello.world";
      expanded  = ph.expand(ph.get(key)) + File.separator + "hello.world";
      assertEquals(expanded, ph.expand(collapsed));
    }
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(PlaceholdersTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
