/*
 * StandalonesTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.standalone;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseRegExp;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;

/**
 * Tests the Standalones actor.
 * <p/>
 * Just uses the WhileLoopTest since it uses a Standalones actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3525 $
 */
public class StandalonesTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public StandalonesTest(String name) {
    super(name);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    DatabaseConnection dbcon = new DatabaseConnection();
    dbcon.setURL(getDatabaseURL());
    dbcon.setUser(getDatabaseUser());
    dbcon.setPassword(getDatabasePassword());

    DatabaseCheck dbc = new DatabaseCheck();
    dbc.setRegExp(new BaseRegExp(".*" + getDatabaseURL().replaceAll(".*\\/", "") + ".*"));

    Tool tl = new Tool();

    Standalones sg = new Standalones();
    sg.setActors(new AbstractActor[]{
	dbcon,
	dbc,
	tl
    });

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{sg});

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(StandalonesTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
