/*
 * MakeLogEntryTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.LogViewer;
import adams.flow.source.StringConstants;
import adams.flow.transformer.MakeLogEntry;
import adams.test.TmpFile;

/**
 * Tests the MakeLogEntry actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3011 $
 */
public class MakeLogEntryTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public MakeLogEntryTest(String name) {
    super(name);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    StringConstants sc = new StringConstants();
    sc.setStrings(new BaseString[]{
	new BaseString("1.0"),
	new BaseString("-1.0"),
	new BaseString("3.1415"),
	new BaseString("-1.4E3"),
	new BaseString("1.4E-3")
    });

    MakeLogEntry mle = new MakeLogEntry();
    mle.setLogSource("JUnit");
    mle.setLogType("Regression test");

    LogViewer lv = new LogViewer();

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{sc, mle, lv});

    return flow;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(MakeLogEntryTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
