/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.IntToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MathExpression;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SubProcessTest
extends AbstractFlowTest {
    public SubProcessTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ForLoop fl = new ForLoop();
        fl.setLoopLower(1);
        fl.setLoopUpper(30);
        fl.setLoopStep(1);
        SubProcess sub = new SubProcess();
        IntToDouble i2d = new IntToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)i2d);
        MathExpression me = new MathExpression();
        me.setExpression("X^2");
        sub.setActors(new AbstractActor[]{con, me});
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{fl, sub, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(SubProcessTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SubProcessTest.runTest(SubProcessTest.suite());
    }
}

