/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.ConsoleObject;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import java.io.File;

public class FilenameProposer
extends ConsoleObject {
    private static final long serialVersionUID = -7253929564700735410L;
    protected String m_Prefix;
    protected String m_Suffix;
    protected String m_Directory;

    public FilenameProposer(String prefix, String suffix) {
        this(prefix, suffix, System.getProperty("user.home"));
    }

    public FilenameProposer(String prefix, String suffix, String directory) {
        this.m_Prefix = prefix;
        this.m_Suffix = suffix.replaceFirst("^\\.", "");
        this.m_Directory = directory;
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public void setDirectory(String value) {
        this.m_Directory = value;
    }

    public String getDirectory() {
        return this.m_Directory;
    }

    public PlaceholderFile propose(File basis) {
        PlaceholderFile result;
        String prefix;
        String dir;
        if (basis == null) {
            dir = this.m_Directory;
            prefix = this.m_Prefix;
        } else if (basis.isDirectory()) {
            dir = basis.getAbsolutePath();
            prefix = this.m_Prefix;
        } else {
            dir = basis.getParentFile().getAbsolutePath();
            prefix = basis.getName().replaceAll("\\..*", "");
            prefix = prefix.replaceAll("[0-9][0-9]*$", "");
        }
        if (dir.endsWith(File.separator + ".")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        int counter = 1;
        while ((result = new PlaceholderFile(dir + File.separator + prefix + ++counter + "." + this.m_Suffix)).exists()) {
        }
        return result;
    }

    public String toString() {
        return "directory=" + this.m_Directory + ", prefix=" + this.m_Prefix + ", suffix=" + this.m_Suffix;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        System.out.println("--> default directory is home");
        FilenameProposer prop = new FilenameProposer("new", ".flow");
        File file = null;
        System.out.println(file + "\n  -> " + prop.propose(file));
        file = new File(".");
        System.out.println(file + "\n  -> " + prop.propose(file));
        file = new File("./blah.flow");
        System.out.println(file + "\n  -> " + prop.propose(file));
    }
}

