/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.FileUtils;
import adams.core.management.OS;
import adams.core.management.ProcessUtils;
import java.io.File;

public class Java {
    public static final String BIN_DIR = "bin";
    public static final String JAVA = "java";
    public static final String JAVAC = "javac";
    protected static String CLASSPATH_FULL;
    protected static String CLASSPATH_SHORT;

    public static String getHome() {
        return System.getProperty("java.home");
    }

    public static boolean isJRE() {
        return Java.isJRE(Java.getHome());
    }

    public static boolean isJRE(String path) {
        String file = path + File.separator + BIN_DIR + File.separator + FileUtils.fixExecutable(JAVAC);
        return !new File(file).exists();
    }

    public static boolean isJDK() {
        return Java.isJDK(Java.getHome());
    }

    public static boolean isJDK(String path) {
        File file = new File(path);
        if (Java.isJRE(path) && file.getParentFile().getName().matches("jdk.*")) {
            file = file.getParentFile();
        }
        String executable = file.getAbsolutePath() + File.separator + BIN_DIR + File.separator + FileUtils.fixExecutable(JAVAC);
        return new File(executable).exists();
    }

    public static String getBinDir() {
        return Java.getBinDir(Java.getHome());
    }

    public static String getBinDir(String path) {
        File file = new File(Java.getHome());
        String result = file.getAbsolutePath() + File.separator + BIN_DIR;
        if (OS.isMac()) {
            if (!new File(result).exists()) {
                result = file.getParentFile().getAbsolutePath() + File.separator + BIN_DIR;
            }
        } else if (Java.isJDK()) {
            result = file.getParentFile().getAbsolutePath() + File.separator + BIN_DIR;
        }
        return result;
    }

    public static String getJavaExecutable() {
        String result = Java.getBinDir() + File.separator + FileUtils.fixExecutable(JAVA);
        return result;
    }

    protected static String execute(String executable, String options) {
        String result;
        String cmd = executable + " " + options;
        try {
            Object output = ProcessUtils.execute(cmd, false);
            result = output instanceof Integer ? "Exit value: " + output : output.toString();
        }
        catch (Exception e) {
            result = e.toString();
            e.printStackTrace();
        }
        return result;
    }

    public static synchronized String getClassPath(boolean shorten) {
        if (CLASSPATH_FULL == null) {
            String sep = System.getProperty("path.separator");
            String[] parts = System.getProperty("java.class.path").split(sep);
            String shortCP = "";
            String fullCP = "";
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].startsWith("._")) continue;
                if (shortCP.length() > 0) {
                    shortCP = shortCP + sep;
                    fullCP = fullCP + sep;
                }
                shortCP = parts[i].toLowerCase().endsWith(".jar") ? shortCP + new File(parts[i]).getName() : shortCP + parts[i];
                fullCP = fullCP + parts[i];
            }
            CLASSPATH_SHORT = shortCP;
            CLASSPATH_FULL = fullCP;
        }
        String result = shorten ? CLASSPATH_SHORT : CLASSPATH_FULL;
        return result;
    }

    public static void main(String[] args) {
        System.out.println("\n--> " + Java.getHome() + " (current java home)");
        System.out.println("JRE? " + Java.isJRE());
        System.out.println("JDK? " + Java.isJDK());
        System.out.println("bin dir? " + Java.getBinDir());
        for (int i = 0; i < args.length; ++i) {
            System.out.println("\n--> " + args[i]);
            System.out.println("JRE? " + Java.isJRE(args[i]));
            System.out.println("JDK? " + Java.isJDK(args[i]));
            System.out.println("bin dir? " + Java.getBinDir(args[i]));
        }
    }
}

