/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.EnumWithCustomDisplay;
import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;

public class MessageDigest
extends AbstractTransformer {
    private static final long serialVersionUID = 8395316814322443892L;
    protected MessageDigestType m_Type;

    @Override
    public String globalInfo() {
        return "Generates a message digest and forwards that. The digest is either generated on the string being passed through or from the content of a file (if a File object is used as input).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", MessageDigestType.MD5);
    }

    public void setType(MessageDigestType value) {
        this.m_Type = value;
        this.reset();
    }

    public MessageDigestType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of message digest (algorithm) to use.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            java.security.MessageDigest md = java.security.MessageDigest.getInstance(this.m_Type.toDisplay());
            if (this.m_InputToken.getPayload() instanceof String) {
                String input = (String)this.m_InputToken.getPayload();
                md.update(input.getBytes());
            } else {
                File file = (File)this.m_InputToken.getPayload();
                DigestInputStream stream = new DigestInputStream(new BufferedInputStream(new FileInputStream(file.getAbsolutePath())), md);
                byte[] buffer = new byte[1024];
                while (stream.read(buffer) != -1) {
                }
            }
            byte[] digest = md.digest();
            StringBuilder hex = new StringBuilder();
            for (byte b : digest) {
                hex.append(Utils.toHex(b));
            }
            this.m_OutputToken = new Token(hex.toString());
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }

    public static enum MessageDigestType implements EnumWithCustomDisplay<MessageDigestType>
    {
        MD2("MD2"),
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private String m_Algorithm;
        private String m_Raw;

        private MessageDigestType(String algorithm) {
            this.m_Algorithm = algorithm;
            this.m_Raw = super.toString();
        }

        @Override
        public String toDisplay() {
            return this.m_Algorithm;
        }

        @Override
        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.m_Algorithm;
        }

        @Override
        public MessageDigestType parse(String s) {
            return MessageDigestType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((MessageDigestType)object).toRaw();
        }

        public static MessageDigestType valueOf(AbstractOption option, String str) {
            MessageDigestType result = null;
            try {
                result = MessageDigestType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (MessageDigestType dt : MessageDigestType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

