/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.gui.core.ExtensionFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class BaseFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -5712455182900852653L;
    protected boolean m_PromptOverwriteFile = true;
    protected boolean m_AutoAppendExtension = false;
    protected String m_DefaultExtension = null;

    public BaseFileChooser() {
        this.initialize();
    }

    public BaseFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initialize();
    }

    public BaseFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    protected void initialize() {
    }

    public void setPromptOverwriteFile(boolean value) {
        this.m_PromptOverwriteFile = value;
    }

    public boolean getPromptOverwriteFile() {
        return this.m_PromptOverwriteFile;
    }

    public void setAutoAppendExtension(boolean value) {
        this.m_AutoAppendExtension = value;
    }

    public boolean getAutoAppendExtension() {
        return this.m_AutoAppendExtension;
    }

    public void setDefaultExtension(String value) {
        this.m_DefaultExtension = value;
    }

    public String getDefaultExtension() {
        return this.m_DefaultExtension;
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        if (!(filter instanceof ExtensionFileFilter) && filter != this.getAcceptAllFileFilter()) {
            throw new IllegalArgumentException("Only instances of " + ExtensionFileFilter.class.getName() + " are accepted!\n" + "Provided: " + filter.getClass().getName());
        }
        super.addChoosableFileFilter(filter);
    }

    @Override
    public void setSelectedFile(File file) {
        File selFile = null;
        if (file != null) {
            selFile = new File(file.getAbsolutePath());
        }
        super.setSelectedFile(selFile);
    }

    @Override
    public File getSelectedFile() {
        return super.getSelectedFile();
    }

    public PlaceholderFile getSelectedPlaceholderFile() {
        File file = super.getSelectedFile();
        if (file != null) {
            return new PlaceholderFile(file);
        }
        return null;
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        File[] files = null;
        if (selectedFiles != null) {
            files = new File[selectedFiles.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                files[i] = new File(selectedFiles[i].getAbsolutePath());
            }
        }
        super.setSelectedFiles(files);
    }

    @Override
    public File[] getSelectedFiles() {
        return super.getSelectedFiles();
    }

    public PlaceholderFile[] getSelectedPlaceholderFiles() {
        File[] files = super.getSelectedFiles();
        PlaceholderFile[] result = new PlaceholderFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PlaceholderFile(files[i]);
        }
        return result;
    }

    protected boolean hasCorrectExtension(File file, String[] extensions) {
        boolean result = false;
        String filename = file.getAbsolutePath().toLowerCase();
        for (int i = 0; i < extensions.length; ++i) {
            if (!filename.endsWith(extensions[i].toLowerCase())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        int result = super.showDialog(parent, approveButtonText);
        if (this.m_AutoAppendExtension) {
            String[] extensions = null;
            extensions = this.getFileFilter() != this.getAcceptAllFileFilter() ? ((ExtensionFileFilter)this.getFileFilter()).getExtensions() : new String[]{this.getDefaultExtension()};
            if (extensions != null) {
                if (this.isMultiSelectionEnabled()) {
                    File[] selfiles = this.getSelectedFiles();
                    for (int i = 0; i < selfiles.length; ++i) {
                        if (this.hasCorrectExtension(selfiles[i], extensions)) continue;
                        selfiles[i] = new File(selfiles[i].getAbsolutePath() + "." + extensions[0]);
                    }
                    this.setSelectedFiles(selfiles);
                } else {
                    File selfile = this.getSelectedFile();
                    if (selfile != null) {
                        if (!this.hasCorrectExtension(selfile, extensions)) {
                            selfile = new File(selfile.getAbsolutePath() + "." + extensions[0]);
                        }
                        this.setSelectedFile(selfile);
                    }
                }
            }
        }
        if (result == 0 && this.getDialogType() == 1 && (this.getFileSelectionMode() == 2 || this.getFileSelectionMode() == 0) && this.getPromptOverwriteFile() && this.getSelectedFile() != null && this.getSelectedFile().exists() && !this.getSelectedFile().isDirectory()) {
            int retVal = JOptionPane.showConfirmDialog(parent, "File '" + this.getSelectedFile() + "' already exists - overwrite?", "File exists already", 1);
            switch (retVal) {
                case 0: {
                    break;
                }
                case 1: {
                    result = this.showSaveDialog(parent);
                    break;
                }
                case 2: {
                    result = 1;
                }
            }
        }
        return result;
    }

    @Override
    public File getCurrentDirectory() {
        return super.getCurrentDirectory();
    }

    public PlaceholderDirectory getCurrentPlaceholderDirectory() {
        File current = super.getCurrentDirectory();
        if (current == null) {
            return null;
        }
        return new PlaceholderDirectory(current);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            super.setCurrentDirectory(null);
        } else {
            super.setCurrentDirectory(dir.getAbsoluteFile());
        }
    }
}

