/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.env.Modules;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutBoxPanel
extends BasePanel {
    private static final long serialVersionUID = -5180917605195603000L;
    protected JPanel m_PanelImage;
    protected JLabel m_LabelImage;
    protected JPanel m_PanelTitle;
    protected JPanel m_PanelModules;
    protected BaseScrollPane m_ScrollPane;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelImage = new JPanel(new BorderLayout());
        this.m_LabelImage = new JLabel(GUIHelper.getLogoImage());
        this.m_PanelImage.add((Component)this.m_LabelImage, "Center");
        this.add((Component)this.m_PanelImage, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "South");
        this.m_PanelTitle = new JPanel();
        this.m_PanelTitle.setLayout(new GridLayout(0, 1));
        this.m_PanelTitle.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        panel.add((Component)this.m_PanelTitle, "Center");
        List<Modules.Module> modules = Modules.getSingleton().getModules();
        this.m_PanelModules = new JPanel(new FlowLayout(0));
        for (Modules.Module module : modules) {
            JPanel panelModule = new JPanel(new BorderLayout());
            panelModule.setBorder(BorderFactory.createBevelBorder(0));
            String tiptext = "";
            if (module.getDescription().length() > 0) {
                if (tiptext.length() > 0) {
                    tiptext = tiptext + "<br>\n";
                }
                tiptext = tiptext + module.getDescription();
            }
            if (module.getAuthor().length() > 0) {
                if (tiptext.length() > 0) {
                    tiptext = tiptext + "<br>\n";
                }
                tiptext = tiptext + module.getAuthor();
            }
            if (module.getOrganization().length() > 0) {
                if (tiptext.length() > 0) {
                    tiptext = tiptext + "<br>\n";
                }
                tiptext = tiptext + module.getOrganization();
            }
            JLabel label = new JLabel(module.getLogo());
            if (tiptext.length() > 0) {
                label.setToolTipText("<html>" + tiptext + "</html>");
            }
            panelModule.add((Component)label, "Center");
            panelModule.add((Component)new JLabel(module.getName(), 0), "South");
            this.m_PanelModules.add(panelModule);
        }
        this.m_ScrollPane = new BaseScrollPane(this.m_PanelModules);
        this.m_ScrollPane.setPreferredSize(new Dimension(75, 100));
        panel.add((Component)this.m_ScrollPane, "South");
    }

    public void setImage(String name) {
        this.m_LabelImage.setIcon(GUIHelper.getIcon(name));
    }

    public void addInfo(String info) {
        this.m_PanelTitle.add(new JLabel(info, 0));
    }
}

