/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.gui.core.BaseTreeNode;
import adams.gui.core.DragAndDropTreeNodeCollection;
import adams.gui.core.TransferableString;
import adams.gui.flow.tree.ClipboardActorContainer;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

public class TreeNodeCollection
extends DragAndDropTreeNodeCollection<Node> {
    private static final long serialVersionUID = 8624532382080344377L;

    public TreeNodeCollection(Node[] nodes) {
        super((BaseTreeNode[])nodes);
    }

    @Override
    public Transferable toTransferable() {
        ClipboardActorContainer result = new ClipboardActorContainer();
        for (int i = 0; i < this.m_Nodes.size(); ++i) {
            result.add(i, ((Node)this.m_Nodes.get(i)).getFullActor());
        }
        return new TransferableString(result.toNestedString());
    }

    public static TreeNodeCollection fromTransferable(Tree tree, Transferable t) {
        ClipboardActorContainer cont;
        Object data;
        TreeNodeCollection result = null;
        try {
            data = t.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            System.err.println("Failed to obtain string data from transferable for TreeNodeCollection:");
            e.printStackTrace();
            data = null;
        }
        if (data != null && (cont = ClipboardActorContainer.fromNestedString(data.toString())) != null) {
            Node[] nodes = new Node[cont.size()];
            for (int i = 0; i < cont.size(); ++i) {
                nodes[i] = new Node(tree, cont.get(i));
            }
            result = new TreeNodeCollection(nodes);
        }
        return result;
    }
}

