/*
 * Iteratable.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

/**
 * For classes that support iteration.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface Iteratable {

  /**
   * Sets the number of iterations to perform.
   * 
   * @param value	the number of iterations
   */
  public void setNumIterations(int value);

  /**
   * Returns the number of iteratons.
   * 
   * @return  		the number of iterations
   */
  public int getNumIterations();

  /**
   * Returns the tip text for this property.
   * 
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String numIterationsTipText();
}
