/*
 * MetaDataProvider.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

/**
 * For classes that provide additional information for their objects. These
 * objects act as keys in the retrieval of the meta-data.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface MetaDataProvider {

  /**
   * Retrieves the meta-data for the given object. Can return null if no
   * meta-data available.
   * 
   * @param key		the object to retrieve the meta-data for
   * @return		the meta-data or null if none available
   */
  public Object getMetaData(Object key);
}
