/**
 * ShallowCopySupporter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

/**
 * Interface for classes that support shallow copying, i.e., basically
 * only the setup without the internal state.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3925 $
 * @param <T> the type of object the shallow copy returns
 */
public interface ShallowCopySupporter<T> {

  /**
   * Returns a shallow copy of itself.
   *
   * @return		the shallow copy
   */
  public T shallowCopy();

  /**
   * Returns a shallow copy of itself.
   *
   * @param expand	whether to expand variables to their current values
   * @return		the shallow copy
   */
  public T shallowCopy(boolean expand);
}
