/*
 * Loggable.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.io;


/**
 * For tools that support output to a log file.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1630 $
 */
public interface Loggable {

  /**
   * Sets the log file.
   *
   * @param value	the file
   */
  public void setLogFile(PlaceholderFile value);

  /**
   * Returns the log file.
   *
   * @return		the file
   */
  public PlaceholderFile getLogFile();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String logFileTipText();
}
