/**
 * AbstractActorJavaCodeProducer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.flow.core.AbstractActor;

/**
 * Ancestor for producers that generate Java code from actors.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2725 $
 */
public abstract class AbstractActorJavaCodeProducer
  extends AbstractJavaCodeProducer {

  /** for serialization. */
  private static final long serialVersionUID = 8418718518287490700L;

  /**
   * The outer most variable name.
   *
   * @return		the variable name
   */
  protected String getOuterVariableName() {
    return "actor";
  }

  /**
   * Hook-method before starting visiting options.
   */
  protected void preProduce() {
    if (!(m_Input instanceof AbstractActor))
      throw new IllegalArgumentException(
	  "Only " + AbstractActor.class.getName() + " objects (and derived ones) can be processed, provided: "
	  + m_Input.getClass().getName());

    super.preProduce();
  }
}
