/*
 * BooleanOption.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.option;

/**
 * Option for boolean flags.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2427 $
 */
public class BooleanOption
  extends AbstractOption {

  /** for serialization. */
  private static final long serialVersionUID = 8842321259180570339L;

  /** in case of a flag option, inverts the sense. I.e., if the flag appears,
   * it turns the option off. */
  protected boolean m_FlagInverts;

  /**
   * Initializes the option. Will always output the default value.
   *
   * @param owner		the owner of this option
   * @param commandline		the commandline string to identify the option
   * @param property 		the name of bean property
   * @param defValue		the default value, if null then the owner's
   * 				current state is used
   */
  protected BooleanOption(OptionManager owner, String commandline, String property,
      Object defValue) {

    this(owner, commandline, property, defValue, true);
  }

  /**
   * Initializes the option.
   *
   * @param owner		the owner of this option
   * @param commandline		the commandline string to identify the option
   * @param property 		the name of bean property
   * @param defValue		the default value, if null then the owner's
   * 				current state is used
   * @param outputDefValue	whether to output the default value or not
   */
  protected BooleanOption(OptionManager owner, String commandline, String property,
      Object defValue, boolean outputDefValue) {

    super(owner, commandline, property, defValue, outputDefValue);

    m_FlagInverts = (Boolean) getDefaultValue();
  }

  /**
   * Returns true if the option is a an inverting flag (= boolean), i.e., by
   * being present it turns an option off.
   *
   * @return		true if the option is a boolean flag
   */
  public boolean isInvertingFlag() {
    return m_FlagInverts;
  }

  /**
   * Returns the commandline option and the property as string.
   *
   * @return			the commandline option and property
   */
  public String toString() {
    return "-" + getCommandline() + "/" + getProperty();
  }
}
