/**
 * FileBasedConsumer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

/**
 * Interface for option consumers that consume file input.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3487 $
 */
public interface FileBasedConsumer {

  /**
   * Returns the description of the file format.
   *
   * @return		the description
   */
  public String getFileFormat();

  /**
   * Returns the default file extension (without the dot).
   *
   * @return		the default extension
   */
  public String getDefaultFileExtension();

  /**
   * Returns the file extensions (without the dot).
   *
   * @return		the extensions
   */
  public String[] getFileExtensions();
}
