/*
 * GlobalDataContainerFilterChangeEvent.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.data.filter.event;

import javax.swing.event.ChangeEvent;

/**
 * Whenever a change in the global data container filter happens,
 * the listeners get notified with this event.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 305 $
 */
public class GlobalDataContainerFilterChangeEvent
  extends ChangeEvent {

  /** for serialization. */
  private static final long serialVersionUID = -4916095762765587184L;

  /**
   * Initializes the event.
   *
   * @param source	the database connection object
   */
  public GlobalDataContainerFilterChangeEvent(Object source) {
    super(source);
  }

  /**
   * Returns the event as string.
   *
   * @return		a string representation of the event
   */
  public String toString() {
    return getClass().getName();
  }
}
