/**
 * ReportConditions.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

/**
 * Interface for conditions classes that use the reports table
 * for retrieving information.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1800 $
 */
public interface ReportConditions {

  /**
   * Sets whether to exclude data containers with reports flagged as dummies
   * or not.
   *
   * @param value 	if true then dummies are excluded
   */
  public void setExcludeDummies(boolean value);

  /**
   * Returns whether data containers with reports flagged as dummies are
   * excluded or not.
   *
   * @return 		true if dummies are to be excluded
   */
  public boolean getExcludeDummies();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String excludeDummiesTipText();

  /**
   * Sets whether to include only data containers with reports flagged as
   * dummies or not.
   *
   * @param value 	if true then only dummies are included
   */
  public void setOnlyDummies(boolean value);

  /**
   * Returns whether only data containers with reports flagged as dummies are
   * included or not.
   *
   * @return 		true if only dummies are to be included
   */
  public boolean getOnlyDummies();

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String onlyDummiesTipText();
}
