/**
 * Article.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Represents the "article" tag.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2504 $
 */
public class Article
  extends AbstractComplexElement {

  /** for serialization. */
  private static final long serialVersionUID = 2654239691264250202L;

  /**
   * Initializes the tag.
   */
  public Article() {
    super("article");
  }

  /**
   * Initializes the tag.
   *
   * @param title	the title of the article
   */
  public Article(String title) {
    this();
    add(new Title(title));
  }
}
