/**
 * Part.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Represents the "part" tag.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2504 $
 */
public class Part
  extends AbstractComplexElement {

  /** for serialization. */
  private static final long serialVersionUID = 5575540523787776054L;

  /**
   * Initializes the tag.
   */
  public Part() {
    super("part");
  }

  /**
   * Initializes the tag.
   *
   * @param title	the title of the part
   */
  public Part(String title) {
    this();
    add(new Title(title));
  }
}
