/**
 * UpdateEventName.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.processor;

import adams.core.ClassLocator;
import adams.flow.core.EventReference;

/**
 <!-- globalinfo-start -->
 * Updates all occurrences of the old event name with the new one.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-old-name &lt;java.lang.String&gt; (property: oldName)
 * &nbsp;&nbsp;&nbsp;The old event name to replace with the new one.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 * <pre>-new-name &lt;java.lang.String&gt; (property: newName)
 * &nbsp;&nbsp;&nbsp;The new event name that replaces the old one.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4255 $
 */
public class UpdateEventName
  extends AbstractNameUpdater<EventReference> {

  /** for serialization. */
  private static final long serialVersionUID = 7133896476260133469L;

  /**
   * Returns a string describing the object.
   *
   * @return 		a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "Updates all occurrences of the old event name with the new one.";
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String oldNameTipText() {
    return "The old event name to replace with the new one.";
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String newNameTipText() {
    return "The new event name that replaces the old one.";
  }

  /**
   * Returns whether the base class that we're looking for to perform the
   * replacement on is a match.
   *
   * @param cls		the class to check
   * @return		true if a match
   */
  protected boolean isBaseClassMatch(Class cls) {
    return ClassLocator.isSubclass(EventReference.class, cls);
  }

  /**
   * Checks whether the located object matches the old name that requires
   * replacement.
   *
   * @param old		the old object to check
   * @param oldName	the old name to look for
   * @return		true if a match
   */
  protected boolean isNameMatch(EventReference old, String oldName) {
    return old.getValue().equals(oldName);
  }

  /**
   * Returns the replacement object.
   *
   * @param old		the old object
   * @param newName	the new name to use
   * @return		the replacement object, null in case of error
   */
  protected EventReference getReplacement(EventReference old, String newName) {
    EventReference	result;

    try {
      result = (EventReference) old.getClass().newInstance();
      result.setValue(newName);
    }
    catch (Exception e) {
      getSystemErr().println("Failed to create instance of " + old.getClass().getName() + ":");
      getSystemErr().printStackTrace(e);
      result = null;
    }

    return result;
  }
}
