/*
 * Child.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.application;

import adams.core.CleanUpHandler;
import adams.core.PrintObject;

/**
 * The interface for the child frames/windows.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3609 $
 */
public interface Child
  extends CleanUpHandler {

  /**
   * returns the parent frame, can be null.
   *
   * @return		the parent frame
   */
  public AbstractApplicationFrame getParentFrame();

  /**
   * Returns the current title.
   *
   * @return		the title
   */
  public String getTitle();

  /**
   * Sets the new title.
   *
   * @param title	the new title
   */
  public void setTitle(String title);

  /**
   * Calls the cleanUp() method if the first component is a CleanUpHandler.
   */
  public void cleanUp();

  /**
   * de-registers the child frame/window with the parent first.
   */
  public void dispose();

  /**
   * Returns whether a new window, containing the same panel, can be created.
   *
   * @return		true if a new window can be created
   */
  public boolean canCreateNewWindow();

  /**
   * Creates a new window of itself.
   *
   * @return		the new window, or null if not possible
   */
  public Child getNewWindow();

  /**
   * Adds a window listener to dispose the frame/window.
   */
  public void addDisposeWindowListener();

  /**
   * Brings the child to the front.
   */
  public void toFront();

  /**
   * Requests the focus for the child.
   */
  public void requestFocus();

  /**
   * Returns the Debugging print object.
   *
   * @return		the print object
   */
  public PrintObject getDebugging();

  /**
   * Returns the SystemOut print object.
   *
   * @return		the print object
   */
  public PrintObject getSystemOut();

  /**
   * Returns the SystemErr print object.
   *
   * @return		the print object
   */
  public PrintObject getSystemErr();
}