/**
 * CustomSearchListModel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import javax.swing.ListModel;

/**
 * Interface for list models that customize how the search identifies a
 * match.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3887 $
 */
public interface CustomSearchListModel
  extends ListModel {

  /**
   * Tests whether the search matches the specified element index.
   *
   * @param params	the search parameters
   * @param index	the element index of the underlying, unsorted model
   * @return		true if the search matches this index
   */
  public boolean isSearchMatch(SearchParameters params, int index);
}
