/*
 * HashtableTableModel.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.core;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

/**
 * The model for displaying a hashtable.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3064 $
 */
public class HashtableTableModel
  extends KeyValuePairTableModel {

  /** for serialization. */
  private static final long serialVersionUID = -8212085458244592181L;

  /**
   * Initializes the table model with no data.
   */
  public HashtableTableModel() {
    super(new String[0][]);
  }

  /**
   * Initializes the table model.
   *
   * @param data	the hashtable to display
   */
  public HashtableTableModel(Hashtable data) {
    super(convert(data));
  }

  /**
   * Turns the hashtable into key-value pairs. The keys are sorted
   * alphabetically.
   *
   * @param data	the data to convert
   * @return		the converted data
   */
  protected static Object[][] convert(Hashtable data) {
    Object[][]	result;

    result = new Object[data.size()][2];
    Vector keys = new Vector(data.keySet());
    Collections.sort(keys);
    for (int i = 0; i < keys.size(); i++) {
      result[i][0] = "" + keys.get(i);
      result[i][1] = data.get(keys.get(i));
    }

    return result;
  }
}