/**
 * TreeModel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.flow.tree;

import javax.swing.tree.DefaultTreeModel;

import adams.core.Destroyable;

/**
 * Specialized tree model for the flow editor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1381 $
 */
public class TreeModel
  extends DefaultTreeModel
  implements Destroyable {

  /** for serialization. */
  private static final long serialVersionUID = 5319049932782128289L;

  /**
   * Initializes the model with no nodes.
   */
  public TreeModel() {
    this(null);
  }

  /**
   * Initializes the tree with the specified root node.
   *
   * @param root	the root node, can be null
   */
  public TreeModel(Node root) {
    super(root);
  }

  /**
   * Recursively destroys all nodes (starting at the leaves).
   *
   * @param parent	the parent to go down from in the hierarchy
   */
  protected void destroy(Node parent) {
    int		i;

    for (i = 0; i < parent.getChildCount(); i++)
      destroy((Node) parent.getChildAt(i));

    parent.destroy();
  }

  /**
   * Frees up memory in a "destructive" non-reversible way.
   */
  public void destroy() {
    destroy((Node) getRoot());
  }
}
