/*
 *    EnumEditor.java
 *    Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.goe;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;

import adams.core.EnumWithCustomDisplay;

/**
 * A PropertyEditor that displays Enums. Based on Weka's SelectedTagEditor.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @author Len Trigg (trigg@cs.waikato.ac.nz)
 * @version $Revision: 644 $
 * @see weka.gui.SelectedTagEditor
 */
public class EnumEditor
  extends PropertyEditorSupport {

  /**
   * Returns a description of the property value as java source.
   *
   * @return 		a value of type 'String'
   */
  public String getJavaInitializationString() {
    String	result;

    result = "Enum.valueOf("
      		+ getValue().getClass().getSimpleName() + ", "
      		+ getValue().toString() + ")";

    return result;
  }

  /**
   * Gets the current value as text.
   *
   * @return 		a value of type 'String'
   */
  public String getAsText() {
    return getValue().toString();
  }

  /**
   * Sets the current property value as text.
   *
   * @param text 	the text of the selected tag.
   */
  public void setAsText(String text) {
    if (getValue() instanceof EnumWithCustomDisplay)
      setValue(((EnumWithCustomDisplay) getValue()).parse(text));
    else
      setValue(Enum.valueOf(getValue().getClass().asSubclass(Enum.class), text));
  }

  /**
   * Gets the list of tags that can be selected from.
   *
   * @return 		an array of string tags.
   */
  public String[] getTags() {
    String[]	result;
    Method	method;
    Object[]	obj;
    int		i;

    try {
      method = getValue().getClass().getMethod("values", new Class[0]);
      obj    = (Object[]) method.invoke(null, new Object[0]);
      result = new String[obj.length];
      for (i = 0; i < obj.length; i++)
	result[i] = obj[i].toString();
    }
    catch (Exception e) {
      e.printStackTrace();
      result = new String[0];
    }

    return result;
  }
}
