/*
 * NullWriter.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.print;

/**
 * Dummy - generates no output.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 152 $
 */
public class NullWriter
  extends JComponentWriter {

  /** for serialization. */
  private static final long serialVersionUID = 6067496733898037178L;

  /**
   * Returns a string describing the object.
   * 
   * @return 		a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Dummy - generates no output.";
  }

  /**
   * returns the name of the writer, to display in the FileChooser.
   * 
   * @return 		the name of the writer
   */
  public String getDescription() {
    return "";
  }
  
  /**
   * returns no extensions.
   * 
   * @return 		zero-length array
   */
  public String[] getExtensions() {
    return new String[]{};
  }
  
  /**
   * generates the actual output.
   * 
   * @throws Exception	if something goes wrong
   */
  public void generateOutput() throws Exception {
  }
}
