/*
 * VisibilityContainer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

/**
 * Interface for containers that encapsulate visibility information as well.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 23 $
 */
public interface VisibilityContainer {
  
  /**
   * Sets the container's visibility.
   * 
   * @param value	if true then the container will be visible
   */
  public void setVisible(boolean value);
  
  /**
   * Returns whether the container is visible.
   * 
   * @return		true if the container is visible
   */
  public boolean isVisible();
}