/*
 * Tick.java
 * Copyright (C) 2008-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.core.axis;

import java.io.Serializable;

/**
 * Represents a single tick of an axis.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2571 $
 */
public class Tick
  implements Serializable {

  /** for serialization. */
  private static final long serialVersionUID = -6608030365327102253L;

  /** the position. */
  protected int m_Position;

  /** the label, if any. */
  protected String m_Label;

  /**
   * Initializes the tick.
   *
   * @param pos	the position of this tick
   * @param label	the label for this tick, null to suppress
   */
  public Tick(int pos, String label) {
    super();

    m_Position = pos;
    m_Label    = label;
  }

  /**
   * Returns the tick's position.
   *
   * @return		the position
   */
  public int getPosition() {
    return m_Position;
  }

  /**
   * Returns whether this is a major tick, i.e., one with a label.
   *
   * @return		true if this is a major tick
   */
  public boolean isMajor() {
    return hasLabel();
  }

  /**
   * Returns whether this is a minor tick, i.e., one without a label.
   *
   * @return		true if this is a minor tick
   */
  public boolean isMinor() {
    return !hasLabel();
  }

  /**
   * Returns whether this tick has a label or not.
   *
   * @return		true if the tick has a label
   */
  public boolean hasLabel() {
    return (m_Label != null);
  }

  /**
   * Returns the label of this tick, can be null.
   *
   * @return		the label
   */
  public String getLabel() {
    return m_Label;
  }

  /**
   * Returns a string representation of the tick.
   *
   * @return		a string representation
   */
  public String toString() {
    return "Tick: " + "pos=" + m_Position + ", label=" + m_Label;
  }
}