/*
 * XYSequenceContainerDisplayIDGenerator.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.sequence;

import adams.gui.visualization.container.AbstractContainerDisplayStringGenerator;

/**
 * Class for generating display IDs for XY sequences.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 952 $
 */
public class XYSequenceContainerDisplayIDGenerator
  extends AbstractContainerDisplayStringGenerator<XYSequenceContainer> {

  /** for serialization. */
  private static final long serialVersionUID = -5479641588217477884L;

  /**
   * Returns the display ID for the sequence.
   *
   * @param c		the sequence to get the display ID for
   * @return		the ID
   */
  public String getDisplay(XYSequenceContainer c) {
    return c.getData().getID();
  }
}