/**
 * NestedProducerConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;

/**
 * Tests the NestedProducer/Consumer classes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class NestedProducerConsumerTest
  extends AbstractOptionProducerConsumerTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public NestedProducerConsumerTest(String name) {
    super(name);
  }

  /**
   * Returns a default producer.
   *
   * @return		the producer
   */
  protected AbstractOptionProducer getProducer() {
    return new NestedProducer();
  }

  /**
   * Returns a default consumer.
   *
   * @return		the consumer
   */
  protected AbstractOptionConsumer getConsumer() {
    return new NestedConsumer();
  }
}
