/**
 * AnyToCommandlineTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.core.base.BaseText;
import adams.data.conversion.AnyToCommandline;
import adams.test.TmpFile;

import java.io.File;

/**
 * Tests the AnyToCommandline conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2879 $
 */
public class AnyToCommandlineTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public AnyToCommandlineTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    Object[]	result;

    result = new Object[3];

    result[0] = new Double(1.78);
    result[1] = new adams.data.filter.PassThrough();
    ((adams.data.filter.PassThrough) result[1]).setDebugLevel(3);
    result[2] = new adams.data.filter.BaselineCorrection();

    return result;
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    return new AbstractConversion[]{new AnyToCommandline()};
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
