/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.AbstractSpreadSheetWriter;
import adams.core.io.CsvSpreadSheetReader;
import adams.core.io.SpreadSheet;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractSpreadSheetWriterTestCase
extends AdamsTestCase {
    public AbstractSpreadSheetWriterTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/core/io/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected boolean save(SpreadSheet data, String filename, AbstractSpreadSheetWriter writer) {
        return writer.write(data, new TmpFile(filename).getAbsolutePath());
    }

    protected abstract String[] getInputFiles();

    protected abstract String[] getOutputFiles();

    protected abstract AbstractSpreadSheetWriter[] getSetups();

    public void testSetups() {
        int i;
        String[] input = this.getInputFiles();
        String[] output = this.getOutputFiles();
        AbstractSpreadSheetWriter[] setups = this.getSetups();
        AbstractSpreadSheetWriterTestCase.assertEquals((String)"Number of input and output files differ!", (int)input.length, (int)output.length);
        AbstractSpreadSheetWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i]);
            AbstractSpreadSheetWriterTestCase.assertNotNull((String)"Failed to load data?", (Object)data);
            boolean ok = this.save(data, output[i], setups[i]);
            AbstractSpreadSheetWriterTestCase.assertTrue((String)"Failed to save data?", (boolean)ok);
        }
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }

    protected boolean hasRegressionTest() {
        return false;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public void testRegression() {
        int i;
        if (!this.hasRegressionTest()) {
            return;
        }
        String[] input = this.getInputFiles();
        String[] output = this.getOutputFiles();
        AbstractSpreadSheetWriter[] setups = this.getSetups();
        AbstractSpreadSheetWriterTestCase.assertEquals((String)"Number of input and output files differ!", (int)input.length, (int)output.length);
        AbstractSpreadSheetWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i]);
            AbstractSpreadSheetWriterTestCase.assertNotNull((String)"Failed to load data?", (Object)data);
            boolean ok = this.save(data, output[i], setups[i]);
            AbstractSpreadSheetWriterTestCase.assertTrue((String)"Failed to save data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractSpreadSheetWriterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

