/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractNumericOptionTest;
import adams.core.option.AbstractOptionTest;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ShortOptionTest
extends AbstractNumericOptionTest {
    public ShortOptionTest(String name) {
        super(name);
    }

    @Override
    protected OptionHandler getOptionHandler() {
        return new ShortOptionClass();
    }

    @Override
    protected String getLowerBoundTestProperty() {
        return "shortObj";
    }

    protected Short getLowerBoundTestValue() {
        return new Short(-100);
    }

    @Override
    protected String getUpperBoundTestProperty() {
        return "shortObj";
    }

    protected Short getUpperBoundTestValue() {
        return new Short(100);
    }

    public static Test suite() {
        return new TestSuite(ShortOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ShortOptionTest.runTest(ShortOptionTest.suite());
    }

    public static class ShortOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = 8286280518774728029L;
        protected short m_ShortPrim;
        protected short[] m_ShortPrimArray;
        protected Short m_ShortObj;
        protected Short[] m_ShortObjArray;

        @Override
        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("short-prim", "shortPrim", (Object)1);
            this.m_OptionManager.add("short-prim-array", "shortPrimArray", (Object)new short[]{1, 2, 3});
            this.m_OptionManager.add("short-obj", "shortObj", (Object)new Short(2), (Number)new Short(-10), (Number)new Short(10));
            this.m_OptionManager.add("short-obj-array", "shortObjArray", (Object)new Short[]{new Short(4), new Short(5), new Short(6)});
        }

        public void setShortPrim(short value) {
            this.m_ShortPrim = value;
        }

        public short getShortPrim() {
            return this.m_ShortPrim;
        }

        public String shortPrimTipText() {
            return "shortPrim";
        }

        public void setShortPrimArray(short[] value) {
            this.m_ShortPrimArray = value;
        }

        public short[] getShortPrimArray() {
            return this.m_ShortPrimArray;
        }

        public String shortPrimArrayTipText() {
            return "shortPrimArray";
        }

        public void setShortObj(Short value) {
            this.m_ShortObj = value;
        }

        public Short getShortObj() {
            return this.m_ShortObj;
        }

        public String shortObjTipText() {
            return "shortObj";
        }

        public void setShortObjArray(Short[] value) {
            this.m_ShortObjArray = value;
        }

        public Short[] getShortObjArray() {
            return this.m_ShortObjArray;
        }

        public String shortObjArrayTipText() {
            return "shortObjArray";
        }
    }
}

