/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.env.Environment;
import adams.flow.core.AdditionalOptions;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AdditionalOptionsTest
extends AdamsTestCase {
    public AdditionalOptionsTest(String name) {
        super(name);
    }

    public void testBoolean() {
        AdditionalOptions add = new AdditionalOptions();
        AdditionalOptionsTest.assertNull((String)"Hashtable should have been empty", (Object)add.getBoolean("blah"));
        AdditionalOptionsTest.assertEquals((String)"Empty hashtable did not return default value", (Object)add.getBoolean("blah", Boolean.valueOf(true)), (Object)new Boolean(true));
        AdditionalOptionsTest.assertEquals((String)"Should have contained no key-value pair", (int)0, (int)add.size());
        add.putBoolean("blah", Boolean.valueOf(false));
        AdditionalOptionsTest.assertEquals((String)"Non-empty hashtable did not return value", (Object)add.getBoolean("blah", Boolean.valueOf(true)), (Object)new Boolean(false));
        AdditionalOptionsTest.assertEquals((String)"Should have contained 1 key-value pair", (int)1, (int)add.size());
    }

    public void testInteger() {
        AdditionalOptions add = new AdditionalOptions();
        AdditionalOptionsTest.assertNull((String)"Hashtable should have been empty", (Object)add.getInteger("blah"));
        AdditionalOptionsTest.assertEquals((String)"Empty hashtable did not return default value", (Object)add.getInteger("blah", Integer.valueOf(1)), (Object)new Integer(1));
        AdditionalOptionsTest.assertEquals((String)"Should have contained no key-value pair", (int)0, (int)add.size());
        add.putInteger("blah", Integer.valueOf(42));
        AdditionalOptionsTest.assertEquals((String)"Non-empty hashtable did not return value", (Object)add.getInteger("blah", Integer.valueOf(1)), (Object)new Integer(42));
        AdditionalOptionsTest.assertEquals((String)"Should have contained 1 key-value pair", (int)1, (int)add.size());
    }

    public void testDouble() {
        AdditionalOptions add = new AdditionalOptions();
        AdditionalOptionsTest.assertNull((String)"Hashtable should have been empty", (Object)add.getDouble("blah"));
        AdditionalOptionsTest.assertEquals((String)"Empty hashtable did not return default value", (Object)add.getDouble("blah", Double.valueOf(3.1415)), (Object)new Double(3.1415));
        AdditionalOptionsTest.assertEquals((String)"Should have contained no key-value pair", (int)0, (int)add.size());
        add.putDouble("blah", Double.valueOf(2.7182));
        AdditionalOptionsTest.assertEquals((String)"Non-empty hashtable did not return value", (Object)add.getDouble("blah", Double.valueOf(3.1415)), (Object)2.7182);
        AdditionalOptionsTest.assertEquals((String)"Should have contained 1 key-value pair", (int)1, (int)add.size());
    }

    public void testString() {
        AdditionalOptions add = new AdditionalOptions();
        AdditionalOptionsTest.assertNull((String)"Hashtable should have been empty", (Object)add.getString("blah"));
        AdditionalOptionsTest.assertEquals((String)"Empty hashtable did not return default value", (String)add.getString("blah", "yeah"), (String)"yeah");
        AdditionalOptionsTest.assertEquals((String)"Should have contained no key-value pair", (int)0, (int)add.size());
        add.putString("blah", "hello");
        AdditionalOptionsTest.assertEquals((String)"Non-empty hashtable did not return value", (String)add.getString("blah", "yeah"), (String)"hello");
        AdditionalOptionsTest.assertEquals((String)"Should have contained 1 key-value pair", (int)1, (int)add.size());
    }

    public void testConstructors() {
        AdditionalOptions add = new AdditionalOptions();
        AdditionalOptionsTest.assertEquals((String)"Should have contained no key-value pair", (int)0, (int)add.size());
        add = new AdditionalOptions("blah=10 hello=world");
        AdditionalOptionsTest.assertEquals((String)"Should have contained 2 key-value pairs", (int)2, (int)add.size());
        AdditionalOptionsTest.assertTrue((String)"Did not contain key 'blah'", (boolean)add.containsKey((Object)"blah"));
        AdditionalOptionsTest.assertTrue((String)"Did not contain key 'hello'", (boolean)add.containsKey((Object)"hello"));
    }

    public static Test suite() {
        return new TestSuite(AdditionalOptionsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        AdditionalOptionsTest.runTest(AdditionalOptionsTest.suite());
    }
}

