/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.env.Environment;
import adams.parser.AbstractExpressionEvaluatorTestCase;
import adams.parser.BaseDateExpression;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BaseDateExpressionTest
extends AbstractExpressionEvaluatorTestCase<Date, BaseDateExpression> {
    public BaseDateExpressionTest(String name) {
        super(name);
    }

    @Override
    protected String[][] getRegressionExpressions() {
        return new String[][]{{"-INF", "+INF", "1999-12-31 +1 DAY", "1999-12-31 +1 WEEK", "1999-12-31 +1 MONTH", "1999-12-31 +1 YEAR", "1999-12-31 -1 DAY", "1999-12-31 -1 WEEK", "1999-12-31 -1 MONTH", "1999-12-31 -1 YEAR", "1999-12-31", "START +1 DAY", "END -1 DAY"}};
    }

    protected BaseDateExpression[] getRegressionSetups() {
        return new BaseDateExpression[]{new BaseDateExpression()};
    }

    public static void testStart() {
        String expr = "START +2 DAY +1 MONTH";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String startStr = "1901-01-01";
        Date start = null;
        Date parsed = null;
        try {
            start = format.parse(startStr);
        }
        catch (Exception e) {
            BaseDateExpressionTest.fail((String)("Failed to generate Date object from '" + startStr + "': " + e));
        }
        try {
            parsed = BaseDateExpression.evaluate((String)expr, (Date)start, null);
        }
        catch (Exception e) {
            BaseDateExpressionTest.fail((String)("Failed to parse expression '" + expr + "': " + e));
        }
        BaseDateExpressionTest.assertNotNull((String)"Generated null date", (Object)parsed);
        BaseDateExpressionTest.assertEquals((String)"Generated different date", (String)"1901-02-03", (String)format.format(parsed));
    }

    public static void testEnd() {
        String expr = "END -2 DAY -1 MONTH";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String endStr = "1901-10-27";
        Date end = null;
        Date parsed = null;
        try {
            end = format.parse(endStr);
        }
        catch (Exception e) {
            BaseDateExpressionTest.fail((String)("Failed to generate Date object from '" + endStr + "': " + e));
        }
        try {
            parsed = BaseDateExpression.evaluate((String)expr, null, (Date)end);
        }
        catch (Exception e) {
            BaseDateExpressionTest.fail((String)("Failed to parse expression '" + expr + "': " + e));
        }
        BaseDateExpressionTest.assertNotNull((String)"Generated null date", (Object)parsed);
        BaseDateExpressionTest.assertEquals((String)"Generated different date", (String)"1901-09-25", (String)format.format(parsed));
    }

    public static Test suite() {
        return new TestSuite(BaseDateExpressionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseDateExpressionTest.runTest(BaseDateExpressionTest.suite());
    }
}

