/*
 * Decompiled with CFR 0.152.
 */
package adams.data.fit;

import adams.data.fit.NonlinearFunction;

public class Exp2
extends NonlinearFunction {
    private static final long serialVersionUID = 1670768051070643034L;

    @Override
    public String globalInfo() {
        return "Exponential function of the form:\nf(x) = a*e^(b*x) + c*e^(d*x)";
    }

    @Override
    public double[] calcDerivatives(double x, double[] a) {
        double[] result = new double[4];
        if (a.length != result.length) {
            throw new IllegalStateException("Number of coefficients differs from number of partial derivatives: " + a.length + " != " + result.length);
        }
        result[0] = Math.exp(a[1] * x);
        result[1] = a[0] * Math.exp(a[1] * x) * x;
        result[2] = Math.exp(a[3] * x);
        result[3] = a[2] * Math.exp(a[3] * x) * x;
        return result;
    }

    @Override
    public double calcY(double x, double[] a) {
        return a[0] * Math.exp(a[1] * x) + a[2] * Math.exp(a[3] * x);
    }
}

