/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.ConsoleObject;
import adams.core.DateFormat;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionProvider;
import adams.db.SimpleResultSet;
import adams.db.TableManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQL
extends ConsoleObject
implements DatabaseConnectionProvider {
    private static final long serialVersionUID = -7708896486343190549L;
    protected boolean m_Debug;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected static TableManager<SQL> m_TableManager;

    public SQL(AbstractDatabaseConnection dbcon) {
        this.m_DatabaseConnection = dbcon;
        this.updatePrefix();
    }

    protected void updatePrefix() {
        String prefix = this.getClass().getName() + "(" + this.getDatabaseConnection().toStringShort() + "/" + this.getDatabaseConnection().hashCode() + ")";
        this.getSystemOut().setPrefix(prefix);
        this.getSystemErr().setPrefix(prefix);
        this.getDebugging().setPrefix(prefix);
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
        this.getDebugging().setEnabled(value);
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    protected void debug(String msg) {
        this.getDebugging().println(msg);
    }

    public String escapeQuotes(String in) {
        String ret = in.replaceAll("'", "\"");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String table) {
        boolean tableExists = false;
        ResultSet rs = null;
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            rs = dbmd.getTables(null, null, table, null);
            tableExists = rs.next();
        }
        catch (SQLException e) {
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                rs = dbmd.getTables(null, null, table, null);
                tableExists = rs.next();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
        return tableExists;
    }

    public SimpleResultSet getSimpleResultSet(String query) throws Exception {
        return new SimpleResultSet(this.getResultSet(query));
    }

    public PreparedStatement prepareStatement(String query) throws Exception {
        return this.prepareStatement(query, false);
    }

    public PreparedStatement prepareStatement(String query, boolean returnKeys) throws Exception {
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        PreparedStatement stmt = null;
        this.debug("Preparing statement for: " + query);
        try {
            stmt = returnKeys ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
        }
        catch (SQLException e) {
            stmt = returnKeys ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
        }
        catch (Exception e) {
            this.getSystemErr().println("Error preparing statement for: " + query);
            this.getSystemErr().printStackTrace(e);
            throw new Exception(e);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String updateString, String table, String where) throws Exception {
        String query = "UPDATE " + table + " SET " + updateString + " WHERE " + where;
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        Statement stmt = null;
        this.debug("Updating: " + query);
        int uc = 0;
        try {
            stmt = connection.createStatement();
            stmt.execute(query);
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = connection.createStatement();
                stmt.execute(query);
            }
            catch (Exception ex) {
                this.getSystemErr().println("Error executing 'update': " + query);
                this.getSystemErr().printStackTrace(ex);
                int n = -1;
                return n;
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            int n = -1;
            return n;
        }
        finally {
            if (stmt != null) {
                uc = stmt.getUpdateCount();
                stmt.close();
            }
        }
        return uc;
    }

    public ResultSet executeGeneratedKeys(String query) throws Exception {
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        Statement stmt = null;
        this.debug("Execute generated keys: " + query);
        try {
            stmt = connection.createStatement();
            stmt.execute(query, 1);
            return stmt.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.getSystemErr().println("Error executing 'executeGeneratedKeys': " + query);
            this.getSystemErr().printStackTrace(e);
            if (stmt != null) {
                stmt.close();
            }
            return null;
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            if (stmt != null) {
                stmt.close();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String query) throws Exception {
        boolean result;
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        if (connection == null) {
            throw new IllegalStateException("Connection object is null (" + this.m_DatabaseConnection.toStringShort() + "/" + this.m_DatabaseConnection.hashCode() + ")!");
        }
        Statement stmt = null;
        this.debug("Execute: " + query);
        try {
            stmt = connection.createStatement();
            result = stmt.execute(query);
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = connection.createStatement();
                result = stmt.execute(query);
            }
            catch (Exception ex) {
                this.getSystemErr().println("Error executing 'execute': " + query);
                this.getSystemErr().printStackTrace(ex);
                result = false;
            }
        }
        catch (Exception e) {
            this.getSystemErr().println("Error executing query: " + query);
            this.getSystemErr().printStackTrace(e);
            result = false;
        }
        finally {
            SQL.close(stmt);
        }
        return result;
    }

    public boolean truncate(String table) {
        boolean result;
        try {
            this.execute("TRUNCATE TABLE " + table);
            result = true;
        }
        catch (Exception e) {
            this.getSystemErr().println("Error truncating table '" + table + "':");
            this.getSystemErr().printStackTrace(e);
            result = false;
        }
        return result;
    }

    public boolean drop(String table) {
        boolean result;
        try {
            this.execute("DROP TABLE " + table);
            result = true;
        }
        catch (Exception e) {
            this.getSystemErr().println("Error dropping table '" + table + "':");
            this.getSystemErr().printStackTrace(e);
            result = false;
        }
        return result;
    }

    public static void close(Statement s) {
        if (s != null) {
            try {
                s.close();
                s = null;
            }
            catch (Exception e) {
                System.err.println("Error closing statement: " + e.toString());
            }
        }
    }

    public static void closeAll(ResultSet r) {
        if (r != null) {
            try {
                Statement s = r.getStatement();
                r.close();
                SQL.close(s);
                s = null;
                r = null;
            }
            catch (Exception e) {
                System.err.println("Error closing resultset: " + e.toString());
            }
        }
    }

    public static void closeAll(SimpleResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception e) {
                System.err.println("Error closing resultset/statement: " + e.toString());
            }
        }
    }

    public ResultSet select(String columns, String tables, String where) throws Exception {
        return this.doSelect(false, columns, tables, where);
    }

    public ResultSet selectDistinct(String columns, String tables, String where) throws Exception {
        return this.doSelect(true, columns, tables, where);
    }

    protected ResultSet doSelect(boolean distinct, String columns, String tables, String where) throws Exception {
        String query = "SELECT ";
        if (distinct) {
            query = query + "DISTINCT ";
        }
        query = query + columns;
        query = query + " FROM " + tables;
        if (where != null && where.length() > 0) {
            if (!where.trim().toUpperCase().startsWith("LIMIT ") && !where.trim().toUpperCase().startsWith("ORDER ")) {
                query = query + " WHERE";
            }
            query = query + " " + where;
        }
        this.debug("doSelect: " + query);
        try {
            return this.getResultSet(query);
        }
        catch (SQLException e) {
            this.getSystemErr().println("Error executing 'doSelect': " + query);
            this.getSystemErr().printStackTrace(e);
            throw e;
        }
    }

    public static int booleanToTinyInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public static boolean tinyIntToBoolean(int i) {
        return i != 0;
    }

    public static String backquote(BaseRegExp s) {
        return SQL.backquote(s.getValue());
    }

    public static String backquote(String s) {
        String result = Utils.backQuoteChars(s);
        if (!result.startsWith("'")) {
            result = "'" + result + "'";
        }
        return result;
    }

    public ResultSet getResultSet(String query) throws Exception {
        Connection connection = this.m_DatabaseConnection.getConnection(true);
        this.debug("Get ResultSet for : " + query);
        if (connection == null) {
            throw new IllegalStateException("Connection object is null!");
        }
        Statement stmt = null;
        try {
            stmt = connection.createStatement(1004, 1007);
        }
        catch (SQLException e) {
            stmt = connection.createStatement(1004, 1007);
        }
        return stmt.executeQuery(query);
    }

    public String toString() {
        return "SQL: " + this.getDatabaseConnection().toString();
    }

    public static DateFormat getTimestampDateFormat() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static synchronized SQL getSingleton(AbstractDatabaseConnection dbcon) {
        if (m_TableManager == null) {
            m_TableManager = new TableManager("SQL", null);
        }
        if (!m_TableManager.has(dbcon)) {
            m_TableManager.add(dbcon, new SQL(dbcon));
        }
        return m_TableManager.get(dbcon);
    }
}

