/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;
import adams.flow.processor.ModifyingProcessor;

public abstract class AbstractActorProcessor
extends AbstractOptionHandler
implements Comparable,
ShallowCopySupporter<AbstractActorProcessor> {
    private static final long serialVersionUID = 3610605513320220903L;

    @Override
    public void reset() {
        super.reset();
    }

    public void process(AbstractActor actor) {
        this.checkData(actor);
        if (actor instanceof ModifyingProcessor) {
            this.processActor(actor.shallowCopy());
        } else {
            this.processActor(actor);
        }
    }

    protected void checkData(AbstractActor actor) {
        if (actor == null) {
            throw new IllegalStateException("No actor provided!");
        }
    }

    protected abstract void processActor(AbstractActor var1);

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractActorProcessor shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractActorProcessor shallowCopy(boolean expand) {
        return (AbstractActorProcessor)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getProcessors() {
        return ClassLister.getSingleton().getClassnames(AbstractActorProcessor.class);
    }

    public static AbstractActorProcessor forName(String classname, String[] options) {
        AbstractActorProcessor result;
        try {
            result = (AbstractActorProcessor)OptionUtils.forName(AbstractActorProcessor.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractActorProcessor forCommandLine(String cmdline) {
        return (AbstractActorProcessor)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

