/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.option.HtmlHelpProducer;
import adams.flow.core.AbstractActor;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.dotnotationtree.AbstractInfoNode;
import adams.gui.core.dotnotationtree.DotNotationNode;
import adams.gui.core.dotnotationtree.PopupMenuHandler;
import adams.gui.dialog.HelpDialog;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.tree.ClipboardActorContainer;
import adams.gui.goe.classtree.ClassNode;
import adams.gui.goe.classtree.ClassTree;
import adams.gui.goe.classtree.GlobalInfoNodeGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class ActorTreePanel
extends BasePanel
implements PopupMenuHandler {
    private static final long serialVersionUID = 4442327828371369542L;
    protected ClassTree m_ClassTree;
    protected SearchPanel m_SearchPanel;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ClassTree = new ClassTree();
        this.m_ClassTree.setCompress(true);
        if (FlowEditorPanel.getProperties().getBoolean("ClassTree.ShowGlobalInfo", true).booleanValue()) {
            this.m_ClassTree.addInfoNodeGenerator(new GlobalInfoNodeGenerator());
        }
        this.m_ClassTree.setItems(Arrays.asList(AbstractActor.getFlowActors()));
        this.m_ClassTree.setPopupMenuHandler(this);
        this.m_ClassTree.addKeyListener(new KeyAdapter(){

            protected String getClassname(BaseTreeNode node) {
                String result = null;
                if (node instanceof AbstractInfoNode) {
                    result = ((AbstractInfoNode)node).getItem();
                } else if (node instanceof ClassNode && ((ClassNode)node).isItemLeaf()) {
                    result = ((ClassNode)node).getItem();
                }
                return result;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath path = ActorTreePanel.this.m_ClassTree.getSelectionPath();
                if (path != null) {
                    KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                    BaseTreeNode selNode = (BaseTreeNode)path.getLastPathComponent();
                    String classname = this.getClassname(selNode);
                    if (classname != null) {
                        if (ks.equals(GUIHelper.getKeyStroke("control C"))) {
                            ActorTreePanel.this.copyToClipboard(classname);
                        } else if (ks.equals(GUIHelper.getKeyStroke("F1"))) {
                            ActorTreePanel.this.showHelp(classname);
                        }
                        e.consume();
                    }
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.add((Component)new BaseScrollPane(this.m_ClassTree), "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false, "_Search", true, null);
        this.m_SearchPanel.setTextColumns(15);
        this.m_SearchPanel.setMinimumChars(2);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                ActorTreePanel.this.m_ClassTree.setSearch(ActorTreePanel.this.m_SearchPanel.getSearchText());
                ActorTreePanel.this.m_SearchPanel.grabFocus();
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_SearchPanel);
        this.add((Component)panel, "South");
    }

    protected JPopupMenu getNodePopup(final String classname) {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
        menuitem.setAccelerator(KeyStroke.getKeyStroke("control C"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorTreePanel.this.copyToClipboard(classname);
            }
        });
        result.add(menuitem);
        result.addSeparator();
        menuitem = new JMenuItem("Help...", GUIHelper.getIcon("help.gif"));
        menuitem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActorTreePanel.this.showHelp(classname);
            }
        });
        result.add(menuitem);
        return result;
    }

    protected void copyToClipboard(String classname) {
        AbstractActor actor = AbstractActor.forCommandLine(classname);
        if (actor == null) {
            return;
        }
        ClipboardActorContainer cont = new ClipboardActorContainer();
        cont.setActors(new AbstractActor[]{actor});
        GUIHelper.copyToClipboard(cont.toNestedString());
    }

    protected void showHelp(String classname) {
        AbstractActor actor = AbstractActor.forCommandLine(classname);
        if (actor == null) {
            return;
        }
        HelpDialog dialog = this.getParentDialog() != null ? new HelpDialog(this.getParentDialog()) : new HelpDialog(this.getParentFrame());
        HtmlHelpProducer producer = new HtmlHelpProducer();
        producer.produce(actor);
        dialog.setHelp(producer.getOutput(), true);
        dialog.setTitle("Help on " + actor.getClass().getName());
        dialog.setLocation(this.getTopLevelAncestor().getLocationOnScreen().x + this.getTopLevelAncestor().getSize().width, this.getTopLevelAncestor().getLocationOnScreen().y);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }

    @Override
    public JPopupMenu getItemNodePopup(DotNotationNode node, boolean isLeaf) {
        if (isLeaf) {
            return this.getNodePopup(node.getItem());
        }
        return null;
    }

    @Override
    public JPopupMenu getInfoNodePopup(AbstractInfoNode node) {
        return this.getNodePopup(node.getItem());
    }

    public void setMinimumChars(int value) {
        this.m_SearchPanel.setMinimumChars(value);
    }

    public int getMinimumChars() {
        return this.m_SearchPanel.getMinimumChars();
    }
}

