/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.option.AbstractOption;
import adams.gui.core.BasePanel;
import adams.gui.core.ColorHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ColorEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected JColorChooser m_ColorChooser;

    public static String toString(AbstractOption option, Object object) {
        return ColorHelper.toHex((Color)object);
    }

    public static Object valueOf(AbstractOption option, String str) {
        Color result = ColorHelper.valueOf(str);
        if (result == null) {
            result = Color.BLACK;
        }
        return result;
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return ColorEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return ColorEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        return "null";
    }

    @Override
    protected JComponent createCustomEditor() {
        Color currentColor = (Color)this.getValue();
        this.m_ColorChooser = new JColorChooser();
        this.m_ColorChooser.setColor(currentColor);
        BasePanel result = new BasePanel(new BorderLayout());
        result.add((Component)this.m_ColorChooser, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        result.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this.setValue(ColorEditor.this.m_ColorChooser.getColor());
                ColorEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setMnemonic('C');
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonCancel);
        return result;
    }

    @Override
    protected void initForDisplay() {
        Color currentColor = (Color)this.getValue();
        if (currentColor != null) {
            this.m_ColorChooser.setColor(currentColor);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        Color color = (Color)this.getValue();
        String val = "No color";
        if (color != null) {
            val = ColorEditor.toString(null, color);
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

