/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.CleanUpHandler;
import adams.event.JobCompleteEvent;
import adams.event.JobCompleteListener;
import adams.event.JobListCompleteEvent;
import adams.event.JobListCompleteListener;
import adams.multiprocess.Job;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class JobList<T extends Job>
implements List<T>,
JobCompleteListener,
CleanUpHandler {
    private static final long serialVersionUID = 4324015262351789451L;
    protected Vector<T> m_Jobs = new Vector();
    protected HashSet<JobListCompleteListener> m_Listeners = new HashSet();
    protected boolean m_Locked = false;
    protected boolean m_Finished = false;

    @Override
    public boolean add(T e) {
        if (this.m_Locked) {
            return false;
        }
        ((Job)e).setJobCompleteListener(this);
        return this.m_Jobs.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.m_Locked) {
            return false;
        }
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            ((Job)iter.next()).setJobCompleteListener(this);
        }
        return this.m_Jobs.addAll(c);
    }

    @Override
    public void add(int index, T element) {
        if (!this.m_Locked) {
            ((Job)element).setJobCompleteListener(this);
            this.m_Jobs.add(index, element);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.m_Locked) {
            return false;
        }
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            ((Job)iter.next()).setJobCompleteListener(this);
        }
        return this.m_Jobs.addAll(index, c);
    }

    @Override
    public void clear() {
        if (!this.m_Locked) {
            this.m_Jobs.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.m_Jobs.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_Jobs.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobList)) {
            return false;
        }
        JobList queue = (JobList)obj;
        if (!this.m_Jobs.equals(queue.m_Jobs)) {
            return false;
        }
        if (!this.m_Listeners.equals(queue.m_Listeners)) {
            return false;
        }
        return this.m_Locked == queue.m_Locked;
    }

    @Override
    public int hashCode() {
        return this.m_Jobs.hashCode();
    }

    @Override
    public T get(int index) {
        return (T)((Job)this.m_Jobs.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.m_Jobs.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.m_Jobs.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.m_Jobs.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.m_Jobs.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.m_Jobs.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.m_Jobs.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        if (this.m_Locked) {
            return false;
        }
        return this.m_Jobs.remove(o);
    }

    @Override
    public T remove(int index) {
        if (this.m_Locked) {
            return null;
        }
        return (T)((Job)this.m_Jobs.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.m_Locked) {
            return false;
        }
        return this.m_Jobs.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.m_Locked) {
            return false;
        }
        return this.m_Jobs.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        if (this.m_Locked) {
            return null;
        }
        ((Job)element).setJobCompleteListener(this);
        return (T)((Job)this.m_Jobs.set(index, element));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        JobList<Job> result = new JobList<Job>();
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add((Job)this.m_Jobs.get(i));
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Jobs.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_Jobs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_Jobs.toArray(a);
    }

    public boolean isLocked() {
        return this.m_Locked;
    }

    public void addJobListCompleteListener(JobListCompleteListener l) {
        this.m_Listeners.add(l);
    }

    public void removeJobListCompleteListener(JobListCompleteListener l) {
        this.m_Listeners.remove(l);
    }

    protected void notifyJobListCompleteListeners(JobListCompleteEvent e) {
        Iterator<JobListCompleteListener> iter = this.m_Listeners.iterator();
        while (iter.hasNext()) {
            iter.next().queueCompleted(e);
        }
    }

    public synchronized boolean isFinished() {
        return this.m_Finished;
    }

    @Override
    public synchronized void jobCompleted(JobCompleteEvent e) {
        boolean finished = true;
        for (Job job : this) {
            if (job.isComplete()) continue;
            finished = false;
            break;
        }
        this.m_Finished = finished;
        if (this.m_Finished) {
            this.notifyJobListCompleteListeners(new JobListCompleteEvent(this));
        }
    }

    @Override
    public void cleanUp() {
        if (this.m_Listeners != null) {
            this.m_Listeners.clear();
        }
        this.clear();
    }
}

