/**
 * CloneSupporter.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

/**
 * Interface for getting around the problem with Java's design flaw in
 * regards to interfaces cannot specify the clone method.
 * See <a href="http://c2.com/cgi/wiki?CloneableDoesNotImplementClone" target="_blank">here</a> for more information.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 490 $
 * @param <T> the type of data that gets returned by the getClone() method
 */
public interface CloneHandler<T> {

  /**
   * Returns a clone of the object.
   *
   * @return		the clone
   */
  public T getClone();
}
