/**
 * NullWriter.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core.io;

/**
 <!-- globalinfo-start -->
 * Performs no writing at all.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 * &nbsp;&nbsp;&nbsp;If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1300 $
 */
public class NullWriter
  extends AbstractTextWriter {

  /** for serialization. */
  private static final long serialVersionUID = 2481561390856324348L;

  /**
   * Returns a short description of the writer.
   *
   * @return		a description of the writer
   */
  public String globalInfo() {
    return "Performs no writing at all.";
  }

  /**
   * Does nothing.
   *
   * @param content	the content to write
   * @param name	the name under which to save the content
   * @return		always null
   */
  public String write(String content, String name) {
    return null;
  }
}
