/**
 * DefaultClassPathAugmenter.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.core.management;

/**
 * Simply returns the CLASSPATH environment variable.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4365 $
 */
public class DefaultClassPathAugmenter
  extends AbstractClassPathAugmenter {

  /**
   * Returns the classpath parts (jars, directories) to add to the classpath.
   * 
   * @return		the additional classpath parts
   */
  public String[] getClassPathAugmentation() {
    String[]	result;
    String	env;
    
    env = System.getenv("CLASSPATH");
    if (env == null)
      result = new String[0];
    else
      result = env.split(System.getProperty("path.separator"));
    
    return result;
  }
}
