/**
 * AbstractDatabaseConnectionFilter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;

/**
 * Ancestor for filters that require database access.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3516 $
 * @param <T> the type of data container to process
 */
public abstract class AbstractDatabaseConnectionFilter<T extends DataContainer>
  extends AbstractFilter<T>
  implements DatabaseConnectionHandler {

  /** for serialization. */
  private static final long serialVersionUID = -6659639627999176470L;

  /** the database connection. */
  protected AbstractDatabaseConnection m_DatabaseConnection;

  /**
   * Initializes the members.
   */
  protected void initialize() {
    super.initialize();

    m_DatabaseConnection = getDefaultDatabaseConnection();
  }

  /**
   * Returns the default database connection.
   *
   * @return		the default database connection
   */
  protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

  /**
   * Returns the currently used database connection object, can be null.
   *
   * @return		the current object
   */
  public AbstractDatabaseConnection getDatabaseConnection() {
    return m_DatabaseConnection;
  }

  /**
   * Sets the database connection object to use.
   *
   * @param value	the object to use
   */
  public void setDatabaseConnection(AbstractDatabaseConnection value) {
    m_DatabaseConnection = value;
    updateDatabaseConnection();
    reset();
  }

  /**
   * Updates the database connection in dependent schemes.
   * <p/>
   * Default implementation does nothing.
   */
  protected void updateDatabaseConnection() {
  }
}
